/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import org.calrissian.mango.net.MoreInetAddresses;
import org.calrissian.mango.types.encoders.AbstractInet6AddressEncoder;

public class Inet6AddressEncoder
extends AbstractInet6AddressEncoder<String> {
    @Override
    public String encode(Inet6Address value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        return InetAddresses.toAddrString(value);
    }

    @Override
    public Inet6Address decode(String value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        return MoreInetAddresses.forIPv6String(value);
    }
}

