/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import org.calrissian.mango.types.encoders.AbstractUnsignedLongEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class UnsignedLongEncoder
extends AbstractUnsignedLongEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(UnsignedLong value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        return EncodingUtils.encodeULong(value.longValue());
    }

    @Override
    public UnsignedLong decode(String value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        Preconditions.checkArgument(value.length() == 16, "The value is not a valid encoding");
        return UnsignedLong.fromLongBits((int)EncodingUtils.fromHex(value));
    }
}

