/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import org.calrissian.mango.types.encoders.AbstractUnsignedIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class UnsignedIntegerEncoder
extends AbstractUnsignedIntegerEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(UnsignedInteger value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        return EncodingUtils.encodeUInt(value.intValue());
    }

    @Override
    public UnsignedInteger decode(String value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        Preconditions.checkArgument(value.length() == 8, "The value is not a valid encoding");
        return UnsignedInteger.fromIntBits((int)EncodingUtils.fromHex(value));
    }
}

