/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import org.calrissian.mango.types.encoders.AbstractLongEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class LongEncoder
extends AbstractLongEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Long value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        return EncodingUtils.encodeULong(value ^ Long.MIN_VALUE);
    }

    @Override
    public Long decode(String value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        Preconditions.checkArgument(value.length() == 16, "The value is not a valid encoding");
        return EncodingUtils.fromHex(value) ^ Long.MIN_VALUE;
    }
}

