/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.calrissian.mango.types.encoders.AbstractBigIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class BigIntegerEncoder
extends AbstractBigIntegerEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static IntegerEncoder integerEncoder = new IntegerEncoder();

    @Override
    public String encode(BigInteger value) {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        byte[] bytes = value.toByteArray();
        int length = bytes.length;
        if (value.signum() < 0) {
            length = -length;
        }
        return integerEncoder.encode(length) + new String(Hex.encodeHex(bytes));
    }

    @Override
    public BigInteger decode(String value) throws TypeDecodingException {
        Preconditions.checkNotNull(value, "Null values are not allowed");
        Preconditions.checkArgument(value.length() > 8, "The value is not a valid encoding");
        try {
            return new BigInteger(Hex.decodeHex(value.substring(8).toCharArray()));
        }
        catch (DecoderException e) {
            throw new TypeDecodingException(e);
        }
    }
}

