/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.hash.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.calrissian.mango.hash.tree.HashLeaf;
import org.calrissian.mango.hash.tree.HashNode;
import org.calrissian.mango.hash.tree.Node;

public class MerkleTree<T extends HashLeaf>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int dimensions = 2;
    private int numLeaves;
    private Node topHash;

    public MerkleTree() {
    }

    public MerkleTree(List<T> leaves) throws IllegalStateException {
        this.topHash = this.buildTop(leaves);
        this.numLeaves = leaves.size();
    }

    public MerkleTree(List<T> leaves, int dimensions) throws IllegalStateException {
        this.dimensions = dimensions;
        this.topHash = this.buildTop(leaves);
        this.numLeaves = leaves.size();
    }

    public Node getTopHash() {
        return this.topHash;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public Integer getNumLeaves() {
        return this.numLeaves;
    }

    private Node buildTop(List<T> leaves) {
        ArrayList<Node> hashNodes = new ArrayList<Node>();
        for (int i = 0; i < leaves.size(); i += this.dimensions) {
            int idx = i + this.dimensions > leaves.size() ? leaves.size() : i + this.dimensions;
            List<T> curLeaves = leaves.subList(i, idx);
            hashNodes.add(curLeaves.size() == 1 ? (Node)curLeaves.get(0) : new HashNode(new ArrayList<Node>(curLeaves)));
        }
        List<Node> finalTree = this.build(hashNodes);
        if (finalTree != null && finalTree.size() > 0) {
            return finalTree.get(0);
        }
        throw new IllegalStateException("Final tree cannot have 0 root nodes.");
    }

    private List<Node> build(List<Node> nodes) {
        List<Node> hashNodes = new ArrayList<Node>();
        for (int i = 0; i < nodes.size(); i += this.dimensions) {
            int idx = i + this.dimensions > nodes.size() ? nodes.size() : i + this.dimensions;
            List<Node> curNodes = nodes.subList(i, idx);
            hashNodes.add(curNodes.size() == 1 ? curNodes.get(0) : new HashNode(new ArrayList<Node>(curNodes)));
        }
        if (hashNodes.size() > 1) {
            hashNodes = this.build(hashNodes);
        }
        return hashNodes;
    }

    public List<T> diff(MerkleTree other) {
        if (this.dimensions != other.dimensions || this.numLeaves != other.numLeaves) {
            throw new IllegalStateException("Trees need to have the same size & dimension to diff.");
        }
        ArrayList<T> differences = new ArrayList<T>();
        if (!other.getTopHash().getHash().equals(this.getTopHash().getHash())) {
            List<Node> nodes1 = this.topHash.getChildren();
            List<Node> nodes2 = other.getTopHash().getChildren();
            if (nodes1 == null) {
                return differences;
            }
            if (nodes1 != null && nodes2 == null) {
                differences.addAll(this.getLeaves(nodes2));
            } else {
                for (int i = 0; i < nodes1.size(); ++i) {
                    if (i < nodes1.size() && nodes2.size() == i) {
                        differences.addAll(this.getLeaves(nodes1.get(i).getChildren()));
                        continue;
                    }
                    differences.addAll(this.diff(nodes1.get(i), nodes2.get(i)));
                }
            }
        }
        return differences;
    }

    private List<T> diff(Node one, Node two) {
        ArrayList<HashLeaf> differences = new ArrayList<HashLeaf>();
        if (!one.getHash().equals(two.getHash())) {
            if (one.getChildren() == null) {
                differences.add((HashLeaf)one);
            } else if (one.getChildren() != null && two.getChildren() == null) {
                differences.addAll(this.getLeaves(one.getChildren()));
            } else {
                for (int i = 0; i < one.getChildren().size(); ++i) {
                    Node node1 = one.getChildren().get(i);
                    Node noe2 = two.getChildren().get(i);
                    differences.addAll(this.diff(node1, noe2));
                }
            }
        }
        return differences;
    }

    private List<T> getLeaves(List<Node> nodes) {
        ArrayList<HashLeaf> leaves = new ArrayList<HashLeaf>();
        for (Node child : nodes) {
            if (child.getChildren() == null) {
                leaves.add((HashLeaf)child);
                continue;
            }
            leaves.addAll(this.getLeaves(child.getChildren()));
        }
        return leaves;
    }

    public String toString() {
        return "MerkleTree{dimensions=" + this.dimensions + ", numLeaves=" + this.numLeaves + ", topHash=" + this.topHash + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleTree)) {
            return false;
        }
        MerkleTree that = (MerkleTree)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        if (this.numLeaves != that.numLeaves) {
            return false;
        }
        return !(this.topHash != null ? !this.topHash.equals(that.topHash) : that.topHash != null);
    }

    public int hashCode() {
        int result = this.dimensions;
        result = 31 * result + this.numLeaves;
        result = 31 * result + (this.topHash != null ? this.topHash.hashCode() : 0);
        return result;
    }
}

