/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.hash.tree;

import java.security.MessageDigest;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.calrissian.mango.hash.tree.Node;

public class HashNode
implements Node {
    private static final long serialVersionUID = 1L;
    protected String hash;
    protected List<Node> children;

    public HashNode() {
    }

    public HashNode(List<Node> children) {
        this.children = children;
        MessageDigest digest = DigestUtils.getMd5Digest();
        for (Node node : children) {
            digest.update((node.getHash() + "\u0000").getBytes());
        }
        this.hash = Hex.encodeHexString(digest.digest());
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public String toString() {
        return "HashNode{hash=" + this.hash + ", children=" + this.children + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashNode)) {
            return false;
        }
        HashNode hashNode = (HashNode)o;
        if (this.hash != null ? !this.hash.equals(hashNode.hash) : hashNode.hash != null) {
            return false;
        }
        return !(this.children != null ? !this.children.equals(hashNode.children) : hashNode.children != null);
    }

    public int hashCode() {
        int result = this.hash != null ? this.hash.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }
}

