/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.Identifiable;
import org.calrissian.mango.domain.entity.Entity;

public class EntityIndex
implements Identifiable {
    private final String type;
    private final String id;

    public EntityIndex(String type, String id) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(id);
        this.type = type;
        this.id = id;
    }

    public EntityIndex(Entity entity) {
        this(entity.getType(), entity.getId());
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityIndex)) {
            return false;
        }
        EntityIndex that = (EntityIndex)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return "EntityIndex{type='" + this.type + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

