/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.calrissian.mango.domain.BaseTupleStore;
import org.calrissian.mango.domain.entity.Entity;

public class BaseEntity
extends BaseTupleStore
implements Entity {
    private final String id;
    private final String type;

    public BaseEntity(String type) {
        this(type, UUID.randomUUID().toString());
    }

    public BaseEntity(String type, String id) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(id);
        this.id = id;
        this.type = type;
    }

    public BaseEntity(Entity entity) {
        this(Preconditions.checkNotNull(entity).getType(), entity.getId());
        this.putAll(entity.getTuples());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return "BaseEntity{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", tuples='" + this.getTuples() + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

