/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;

public class BaseTupleStore
implements TupleStore {
    private Multimap<String, Tuple> tuples = ArrayListMultimap.create();

    @Override
    public void put(Tuple tuple) {
        Preconditions.checkNotNull(tuple);
        Preconditions.checkNotNull(tuple.getKey());
        this.tuples.put(tuple.getKey(), tuple);
    }

    @Override
    public void putAll(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples);
        for (Tuple tuple : tuples) {
            this.put(tuple);
        }
    }

    @Override
    public Collection<Tuple> getTuples() {
        return Collections.unmodifiableCollection(this.tuples.values());
    }

    @Override
    public Collection<Tuple> getAll(String key) {
        Preconditions.checkNotNull(key);
        return this.tuples.get(key);
    }

    @Override
    public <T> Tuple<T> get(String key) {
        return this.tuples.containsKey(key) ? this.tuples.get(key).iterator().next() : null;
    }

    @Override
    public Set<String> keys() {
        return this.tuples.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.tuples.containsKey(key);
    }

    @Override
    public <T> Tuple<T> remove(Tuple<T> t) {
        Collection<Tuple> tupelSet;
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(t.getKey());
        if (this.tuples.containsKey(t.getKey()) && (tupelSet = this.tuples.get(t.getKey())).remove(t)) {
            return t;
        }
        return null;
    }

    @Override
    public <T> Tuple<T> remove(String key) {
        Preconditions.checkNotNull(key);
        if (this.tuples.containsKey(key)) {
            Tuple t;
            Collection<Tuple> tupleSet = this.tuples.get(key);
            Tuple tuple = t = tupleSet.size() > 0 ? tupleSet.iterator().next() : null;
            if (t != null && this.tuples.get(key).remove(t)) {
                return t;
            }
        }
        return null;
    }

    @Override
    public Collection<Tuple> removeAll(String key) {
        Preconditions.checkNotNull(key);
        return this.tuples.removeAll(key);
    }

    @Override
    public Collection<Tuple> removeAll(Collection<Tuple> tuples) {
        Preconditions.checkNotNull(tuples);
        ArrayList<Tuple> removedTuples = new ArrayList<Tuple>();
        for (Tuple tuple : tuples) {
            removedTuples.add(this.remove(tuple));
        }
        return removedTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTupleStore)) {
            return false;
        }
        BaseTupleStore that = (BaseTupleStore)o;
        return this.tuples.equals(that.tuples);
    }

    public int hashCode() {
        return this.tuples.hashCode();
    }

    @Override
    public int size() {
        return this.tuples.size();
    }
}

