/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.calrissian.mango.collect.CloseableIterator;
import org.calrissian.mango.collect.Iterators2;
import org.calrissian.mango.collect.PeekingCloseableIterator;

public class CloseableIterators {
    private static final CloseableIterator EMPTY_ITERATOR = CloseableIterators.wrap(Iterators.emptyIterator());

    private CloseableIterators() {
    }

    public static <T> CloseableIterator<T> distinct(CloseableIterator<T> iterator) {
        return CloseableIterators.wrap(Iterators2.distinct(iterator), iterator);
    }

    public static <T> CloseableIterator<List<T>> groupBy(CloseableIterator<? extends T> iterator, Function<? super T, ?> groupingFunction) {
        return CloseableIterators.wrap(Iterators2.groupBy(iterator, groupingFunction), iterator);
    }

    public static <T> CloseableIterator<T> concat(CloseableIterator<? extends Iterator<? extends T>> iterators) {
        return CloseableIterators.wrap(Iterators.concat(iterators), iterators);
    }

    public static <T> CloseableIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> CloseableIterator<T> filter(CloseableIterator<T> iterator, Predicate<T> filter) {
        return CloseableIterators.wrap(Iterators.filter(iterator, filter), iterator);
    }

    public static <T> CloseableIterator<T> filter(CloseableIterator<?> iterator, Class<T> type) {
        return CloseableIterators.wrap(Iterators.filter(iterator, type), iterator);
    }

    public static <T> CloseableIterator<T> limit(CloseableIterator<T> iterator, int limitSize) {
        return CloseableIterators.wrap(Iterators.limit(iterator, limitSize), iterator);
    }

    public static <T> CloseableIterator<List<T>> paddedParition(CloseableIterator<T> iterator, int size) {
        return CloseableIterators.wrap(Iterators.paddedPartition(iterator, size), iterator);
    }

    public static <T> CloseableIterator<List<T>> partition(CloseableIterator<T> iterator, int size) {
        return CloseableIterators.wrap(Iterators.partition(iterator, size), iterator);
    }

    public static <T> PeekingCloseableIterator<T> peekingIterator(final CloseableIterator<T> iterator) {
        final PeekingIterator<T> peeking = Iterators.peekingIterator(iterator);
        return new PeekingCloseableIterator<T>(){

            @Override
            public void closeQuietly() {
                iterator.closeQuietly();
            }

            @Override
            public void close() throws IOException {
                iterator.close();
            }

            @Override
            public T peek() {
                return peeking.peek();
            }

            @Override
            public T next() {
                return peeking.next();
            }

            @Override
            public void remove() {
                peeking.remove();
            }

            @Override
            public boolean hasNext() {
                return peeking.hasNext();
            }
        };
    }

    public static <T> CloseableIterator<T> singletonIterator(T value) {
        return CloseableIterators.wrap(Iterators.singletonIterator(value));
    }

    public static <F, T> CloseableIterator<T> transform(CloseableIterator<F> iterator, Function<F, T> function) {
        return CloseableIterators.wrap(Iterators.transform(iterator, function), iterator);
    }

    @SafeVarargs
    public static <T> CloseableIterator<T> chain(CloseableIterator<? extends T> ... iterators) {
        return CloseableIterators.chain(Iterators.forArray(iterators));
    }

    public static <T> CloseableIterator<T> chain(final Iterator<? extends CloseableIterator<? extends T>> iterator) {
        Preconditions.checkNotNull(iterator);
        return new CloseableIterator<T>(){
            CloseableIterator<? extends T> curr = CloseableIterators.emptyIterator();

            @Override
            public void closeQuietly() {
                try {
                    Closeables.close(this, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void close() throws IOException {
                if (this.curr != null) {
                    this.curr.closeQuietly();
                }
                while (iterator.hasNext()) {
                    ((CloseableIterator)iterator.next()).closeQuietly();
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && iterator.hasNext()) {
                    this.curr = CloseableIterators.autoClose((CloseableIterator)iterator.next());
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.curr.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.curr.remove();
            }
        };
    }

    public static <T> CloseableIterator<T> autoClose(final CloseableIterator<? extends T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new CloseableIterator<T>(){
            private boolean closed = false;

            @Override
            public void closeQuietly() {
                try {
                    Closeables.close(this, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                iterator.close();
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.closed) {
                        return false;
                    }
                    if (!iterator.hasNext()) {
                        this.closeQuietly();
                        return false;
                    }
                    return true;
                }
                catch (RuntimeException re) {
                    this.closeQuietly();
                    throw re;
                }
            }

            @Override
            public T next() {
                if (!this.closed) {
                    try {
                        return iterator.next();
                    }
                    catch (RuntimeException re) {
                        this.closeQuietly();
                        throw re;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.closed) {
                    try {
                        iterator.remove();
                    }
                    catch (RuntimeException re) {
                        this.closeQuietly();
                        throw re;
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    public static <T> CloseableIterator<T> wrap(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new CloseableIterator<T>(){

            @Override
            public void closeQuietly() {
                try {
                    Closeables.close(this, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void close() throws IOException {
                if (iterator instanceof Closeable) {
                    ((Closeable)((Object)iterator)).close();
                }
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final Closeable closeable) {
        return new CloseableIterator<T>(){

            @Override
            public void closeQuietly() {
                try {
                    Closeables.close(this, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void close() throws IOException {
                closeable.close();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

