/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Configurator;
import net.fortuna.ical4j.util.ResourceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeZoneRegistryImpl
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "zoneinfo/";
    private static final Pattern TZ_ID_SUFFIX = Pattern.compile("(?<=/)[^/]*/[^/]*$");
    private static final String UPDATE_ENABLED = "net.fortuna.ical4j.timezone.update.enabled";
    private static final Map DEFAULT_TIMEZONES = new ConcurrentHashMap();
    private static final Properties ALIASES = new Properties();
    private Map timezones;
    private String resourcePrefix;

    public TimeZoneRegistryImpl() {
        this(DEFAULT_RESOURCE_PREFIX);
    }

    public TimeZoneRegistryImpl(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.timezones = new ConcurrentHashMap();
    }

    public final void register(TimeZone timezone) {
        this.register(timezone, false);
    }

    public final void register(TimeZone timezone, boolean update) {
        if (update) {
            this.timezones.put(timezone.getID(), new TimeZone(this.updateDefinition(timezone.getVTimeZone())));
        } else {
            this.timezones.put(timezone.getID(), timezone);
        }
    }

    public final void clear() {
        this.timezones.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TimeZone getTimeZone(String id) {
        TimeZone timezone = (TimeZone)this.timezones.get(id);
        if (timezone == null && (timezone = (TimeZone)DEFAULT_TIMEZONES.get(id)) == null) {
            String alias = ALIASES.getProperty(id);
            if (alias != null) {
                return this.getTimeZone(alias);
            }
            Map map = DEFAULT_TIMEZONES;
            synchronized (map) {
                timezone = (TimeZone)DEFAULT_TIMEZONES.get(id);
                if (timezone == null) {
                    try {
                        Matcher matcher;
                        VTimeZone vTimeZone = this.loadVTimeZone(id);
                        if (vTimeZone != null) {
                            timezone = new TimeZone(vTimeZone);
                            DEFAULT_TIMEZONES.put(timezone.getID(), timezone);
                        } else if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") && (matcher = TZ_ID_SUFFIX.matcher(id)).find()) {
                            return this.getTimeZone(matcher.group());
                        }
                    }
                    catch (Exception e) {
                        Log log = LogFactory.getLog(TimeZoneRegistryImpl.class);
                        log.warn("Error occurred loading VTimeZone", e);
                    }
                }
            }
        }
        return timezone;
    }

    private VTimeZone loadVTimeZone(String id) throws IOException, ParserException {
        URL resource = ResourceLoader.getResource(this.resourcePrefix + id + ".ics");
        if (resource != null) {
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build(resource.openStream());
            VTimeZone vTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
            if (!"false".equals(Configurator.getProperty(UPDATE_ENABLED))) {
                return this.updateDefinition(vTimeZone);
            }
            return vTimeZone;
        }
        return null;
    }

    private VTimeZone updateDefinition(VTimeZone vTimeZone) {
        TzUrl tzUrl = vTimeZone.getTimeZoneUrl();
        if (tzUrl != null) {
            try {
                CalendarBuilder builder = new CalendarBuilder();
                Calendar calendar = builder.build(tzUrl.getUri().toURL().openStream());
                VTimeZone updatedVTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
                if (updatedVTimeZone != null) {
                    return updatedVTimeZone;
                }
            }
            catch (Exception e) {
                Log log = LogFactory.getLog(TimeZoneRegistryImpl.class);
                log.warn("Unable to retrieve updates for timezone: " + vTimeZone.getTimeZoneId().getValue(), e);
            }
        }
        return vTimeZone;
    }

    static {
        try {
            ALIASES.load(ResourceLoader.getResourceAsStream("net/fortuna/ical4j/model/tz.alias"));
        }
        catch (IOException ioe) {
            LogFactory.getLog(TimeZoneRegistryImpl.class).warn("Error loading timezone aliases: " + ioe.getMessage());
        }
    }
}

