/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.visitor;

import com.github.vincentrussell.query.mongodb.sql.converter.holder.ExpressionHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.lang.mutable.MutableBoolean;

public class WhereVisitorMatchAndLookupPipelineMatchBuilder
extends ExpressionVisitorAdapter {
    private String baseAliasTable;
    private ExpressionHolder outputMatch = null;
    private MutableBoolean haveOrExpression = new MutableBoolean();
    private boolean isBaseAliasOrValue;

    public WhereVisitorMatchAndLookupPipelineMatchBuilder(String baseAliasTable, ExpressionHolder outputMatch, MutableBoolean haveOrExpression) {
        this.baseAliasTable = baseAliasTable;
        this.outputMatch = outputMatch;
        this.haveOrExpression = haveOrExpression;
    }

    private ExpressionHolder setOrAndExpression(ExpressionHolder baseExp, Expression newExp) {
        Expression exp = baseExp.getExpression() != null ? new AndExpression(baseExp.getExpression(), newExp) : newExp;
        baseExp.setExpression(exp);
        return baseExp;
    }

    @Override
    public void visit(Column column) {
        if (SqlUtils.isColumn(column)) {
            this.isBaseAliasOrValue = SqlUtils.isTableAliasOfColumn(column, this.baseAliasTable);
        }
    }

    @Override
    public void visit(OrExpression expr) {
        this.haveOrExpression.setValue(true);
    }

    @Override
    public void visit(IsNullExpression expr) {
        if (this.isBaseAliasOrValue) {
            this.setOrAndExpression(this.outputMatch, expr);
        }
    }

    @Override
    protected void visitBinaryExpression(BinaryExpression expr) {
        this.isBaseAliasOrValue = true;
        expr.getLeftExpression().accept(this);
        if (!this.isBaseAliasOrValue) {
            expr.getRightExpression().accept(this);
        } else {
            expr.getRightExpression().accept(this);
            if (this.isBaseAliasOrValue && !(expr instanceof AndExpression) && !(expr instanceof OrExpression)) {
                this.setOrAndExpression(this.outputMatch, expr);
            }
        }
    }
}

