/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.util;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.Token;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.WhereCauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.DateFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.ObjectIdFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.RegexFunction;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.bson.Document;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SqlUtils {
    private static Pattern SURROUNDED_IN_QUOTES = Pattern.compile("^\"(.+)*\"$");
    private static Pattern LIKE_RANGE_REGEX = Pattern.compile("(\\[.+?\\])");
    private static final String REGEXMATCH_FUNCTION = "regexMatch";
    private static final String NOT_REGEXMATCH_FUNCTION = "notRegexMatch";
    private static final String OBJECTID_FUNCTION = "objectId";
    private static final List<String> SPECIALTY_FUNCTIONS = Arrays.asList("regexMatch", "notRegexMatch", "objectId");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final DateTimeFormatter YY_MM_DDFORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    private static final DateTimeFormatter YYMMDDFORMATTER = DateTimeFormat.forPattern("yyyyMMdd");
    private static final Collection<DateTimeFormatter> FORMATTERS = Collections.unmodifiableList(Arrays.asList(ISODateTimeFormat.dateTime(), YY_MM_DDFORMATTER, YYMMDDFORMATTER));

    private SqlUtils() {
    }

    public static String getStringValue(Expression expression) {
        if (StringValue.class.isInstance(expression)) {
            return ((StringValue)expression).getValue();
        }
        if (Column.class.isInstance(expression)) {
            String columnName = expression.toString();
            Matcher matcher = SURROUNDED_IN_QUOTES.matcher(columnName);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return columnName;
        }
        return expression.toString();
    }

    public static Object getValue(Expression incomingExpression, Expression otherSide, FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) throws ParseException {
        FieldType fieldType;
        FieldType fieldType2 = fieldType = otherSide != null ? MoreObjects.firstNonNull(fieldNameToFieldTypeMapping.get(SqlUtils.getStringValue(otherSide)), defaultFieldType) : FieldType.UNKNOWN;
        if (LongValue.class.isInstance(incomingExpression)) {
            return SqlUtils.normalizeValue(((LongValue)incomingExpression).getValue(), fieldType);
        }
        if (SignedExpression.class.isInstance(incomingExpression)) {
            return SqlUtils.normalizeValue(((SignedExpression)incomingExpression).toString(), fieldType);
        }
        if (StringValue.class.isInstance(incomingExpression)) {
            return SqlUtils.normalizeValue(((StringValue)incomingExpression).getValue(), fieldType);
        }
        if (Column.class.isInstance(incomingExpression)) {
            return SqlUtils.normalizeValue(SqlUtils.getStringValue(incomingExpression), fieldType);
        }
        throw new ParseException("can not parseNaturalLanguageDate: " + incomingExpression.toString());
    }

    public static boolean isSpecialtyFunction(Expression incomingExpression) {
        if (incomingExpression == null) {
            return false;
        }
        return net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression) && SqlUtils.containsIgnoreCase(SPECIALTY_FUNCTIONS, ((net.sf.jsqlparser.expression.Function)incomingExpression).getName());
    }

    public static boolean containsIgnoreCase(List<String> list, String soughtFor) {
        for (String current : list) {
            if (!current.equalsIgnoreCase(soughtFor)) continue;
            return true;
        }
        return false;
    }

    public static Object parseFunctionArguments(ExpressionList parameters, final FieldType defaultFieldType, final Map<String, FieldType> fieldNameToFieldTypeMapping) {
        if (parameters == null) {
            return null;
        }
        if (parameters.getExpressions().size() == 1) {
            return SqlUtils.getStringValue(parameters.getExpressions().get(0));
        }
        return Lists.newArrayList(Lists.transform(parameters.getExpressions(), new Function<Expression, Object>(){

            @Override
            public Object apply(Expression expression) {
                try {
                    return SqlUtils.getValue(expression, null, defaultFieldType, fieldNameToFieldTypeMapping);
                }
                catch (ParseException e) {
                    return SqlUtils.getStringValue(expression);
                }
            }
        }));
    }

    public static Object normalizeValue(Object value, FieldType fieldType) throws ParseException {
        if (fieldType == null || FieldType.UNKNOWN.equals((Object)fieldType)) {
            Object bool = SqlUtils.forceBool(value);
            return bool != null ? bool : value;
        }
        if (FieldType.STRING.equals((Object)fieldType)) {
            return SqlUtils.fixDoubleSingleQuotes(SqlUtils.forceString(value));
        }
        if (FieldType.NUMBER.equals((Object)fieldType)) {
            return SqlUtils.forceNumber(value);
        }
        if (FieldType.DATE.equals((Object)fieldType)) {
            return SqlUtils.forceDate(value);
        }
        if (FieldType.BOOLEAN.equals((Object)fieldType)) {
            return Boolean.valueOf(value.toString());
        }
        throw new ParseException("could not normalize value:" + value);
    }

    private static long getLongFromStringIfInteger(String svalue) throws ParseException {
        BigInteger bigInt = new BigInteger(svalue);
        SqlUtils.isFalse(bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0, svalue + ": value is too large");
        return bigInt.longValue();
    }

    public static long getLimit(Limit limit) throws ParseException {
        if (limit != null) {
            return SqlUtils.getLongFromStringIfInteger(SqlUtils.getStringValue(limit.getRowCount()));
        }
        return -1L;
    }

    public static long getOffset(Offset offset) {
        if (offset != null) {
            return offset.getOffset();
        }
        return -1L;
    }

    public static String fixDoubleSingleQuotes(String regex) {
        return regex.replaceAll("''", "'");
    }

    public static boolean isSelectAll(List<SelectItem> selectItems) {
        if (selectItems != null && selectItems.size() == 1) {
            SelectItem firstItem = selectItems.get(0);
            return AllColumns.class.isInstance(firstItem);
        }
        return false;
    }

    public static boolean isCountAll(List<SelectItem> selectItems) {
        net.sf.jsqlparser.expression.Function function;
        SelectItem firstItem;
        return selectItems != null && selectItems.size() == 1 && SelectExpressionItem.class.isInstance(firstItem = selectItems.get(0)) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)firstItem).getExpression()) && "count(*)".equals((function = (net.sf.jsqlparser.expression.Function)((SelectExpressionItem)firstItem).getExpression()).toString());
    }

    public static Object forceBool(Object value) {
        if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false")) {
            return Boolean.valueOf(value.toString());
        }
        return null;
    }

    public static Object forceDate(Object value) throws ParseException {
        if (String.class.isInstance(value)) {
            for (DateTimeFormatter formatter : FORMATTERS) {
                try {
                    DateTime dt = formatter.parseDateTime((String)value);
                    return dt.toDate();
                }
                catch (Exception exception) {
                }
            }
            try {
                return SqlUtils.parseNaturalLanguageDate((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("could not convert " + value + " to a date");
    }

    public static Date parseNaturalLanguageDate(String text) {
        Parser parser = new Parser();
        List<DateGroup> groups = parser.parse(text);
        for (DateGroup group : groups) {
            List<Date> dates = group.getDates();
            if (dates.size() <= 0) continue;
            return dates.get(0);
        }
        throw new IllegalArgumentException("could not natural language date: " + text);
    }

    public static Object forceNumber(Object value) throws ParseException {
        if (String.class.isInstance(value)) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e1) {
                try {
                    return Double.parseDouble((String)value);
                }
                catch (NumberFormatException e2) {
                    try {
                        return Float.valueOf(Float.parseFloat((String)value));
                    }
                    catch (NumberFormatException e3) {
                        throw new ParseException("could not convert " + value + " to number");
                    }
                }
            }
        }
        return value;
    }

    public static String forceString(Object value) {
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        return "" + value + "";
    }

    public static ParseException convertParseException(net.sf.jsqlparser.parser.ParseException incomingException) {
        try {
            return new ParseException(new Token(incomingException.currentToken.kind, incomingException.currentToken.image), incomingException.expectedTokenSequences, incomingException.tokenImage);
        }
        catch (NullPointerException e1) {
            if (incomingException.getMessage().startsWith("Encountered \" \"(\" \"( \"\"")) {
                return new ParseException("Only one simple table name is supported.");
            }
            if (incomingException.getMessage().startsWith("Encountered unexpected token: \"=\" \"=\"")) {
                return new ParseException("unable to parse complete sql string. one reason for this is the use of double equals (==).");
            }
            if (incomingException.getMessage().contains("Was expecting:" + LINE_SEPARATOR + "    \"SELECT\"")) {
                return new ParseException("Only select statements are supported.");
            }
            if (incomingException.getMessage() != null) {
                return new ParseException(incomingException.getMessage());
            }
            return new ParseException("Count not parseNaturalLanguageDate query.");
        }
    }

    public static String replaceRegexCharacters(String value) {
        String newValue = value.replaceAll("%", ".*").replaceAll("_", ".{1}");
        Matcher m = LIKE_RANGE_REGEX.matcher(newValue);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + "{1}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<String> getGroupByColumnReferences(PlainSelect plainSelect) {
        if (plainSelect.getGroupBy() == null) {
            return Collections.emptyList();
        }
        return Lists.transform(plainSelect.getGroupBy().getGroupByExpressions(), new Function<Expression, String>(){

            @Override
            public String apply(@Nonnull Expression expression) {
                return SqlUtils.getStringValue(expression);
            }
        });
    }

    public static String replaceGroup(String source, int groupToReplace, int groupOccurrence, String replacement) {
        Matcher m = LIKE_RANGE_REGEX.matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }

    public static ObjectIdFunction isObjectIdFunction(final WhereCauseProcessor whereCauseProcessor, Expression incomingExpression) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function;
            ComparisonOperator comparisonOperator = (ComparisonOperator)incomingExpression;
            String rightExpression = SqlUtils.getStringValue(comparisonOperator.getRightExpression());
            if (net.sf.jsqlparser.expression.Function.class.isInstance(comparisonOperator.getLeftExpression()) && "objectid".equals((function = (net.sf.jsqlparser.expression.Function)comparisonOperator.getLeftExpression()).getName().toLowerCase()) && function.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function.getParameters().getExpressions().get(0))) {
                String column = SqlUtils.getStringValue(function.getParameters().getExpressions().get(0));
                return new ObjectIdFunction(column, rightExpression, comparisonOperator);
            }
        } else if (InExpression.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function;
            InExpression inExpression = (InExpression)incomingExpression;
            final Expression leftExpression = ((InExpression)incomingExpression).getLeftExpression();
            if (net.sf.jsqlparser.expression.Function.class.isInstance(inExpression.getLeftExpression()) && "objectid".equals((function = (net.sf.jsqlparser.expression.Function)inExpression.getLeftExpression()).getName().toLowerCase()) && function.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function.getParameters().getExpressions().get(0))) {
                String column = SqlUtils.getStringValue(function.getParameters().getExpressions().get(0));
                List<Object> rightExpression = Lists.transform(((ExpressionList)inExpression.getRightItemsList()).getExpressions(), new Function<Expression, Object>(){

                    @Override
                    public Object apply(Expression expression) {
                        try {
                            return whereCauseProcessor.parseExpression(new Document(), expression, leftExpression);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return new ObjectIdFunction(column, rightExpression, inExpression);
            }
        }
        return null;
    }

    public static DateFunction isDateFunction(Expression incomingExpression) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function;
            ComparisonOperator comparisonOperator = (ComparisonOperator)incomingExpression;
            String rightExpression = SqlUtils.getStringValue(comparisonOperator.getRightExpression());
            if (net.sf.jsqlparser.expression.Function.class.isInstance(comparisonOperator.getLeftExpression()) && "date".equals((function = (net.sf.jsqlparser.expression.Function)comparisonOperator.getLeftExpression()).getName().toLowerCase()) && function.getParameters().getExpressions().size() == 2 && StringValue.class.isInstance(function.getParameters().getExpressions().get(1))) {
                String column = SqlUtils.getStringValue(function.getParameters().getExpressions().get(0));
                DateFunction dateFunction = null;
                try {
                    dateFunction = new DateFunction(((StringValue)function.getParameters().getExpressions().get(1)).getValue(), rightExpression, column);
                    dateFunction.setComparisonFunction(comparisonOperator);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
                return dateFunction;
            }
        }
        return null;
    }

    public static RegexFunction isRegexFunction(Expression incomingExpression) throws ParseException {
        net.sf.jsqlparser.expression.Function function;
        if (EqualsTo.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function2;
            EqualsTo equalsTo = (EqualsTo)incomingExpression;
            String rightExpression = equalsTo.getRightExpression().toString();
            if (net.sf.jsqlparser.expression.Function.class.isInstance(equalsTo.getLeftExpression()) && (REGEXMATCH_FUNCTION.equalsIgnoreCase((function2 = (net.sf.jsqlparser.expression.Function)equalsTo.getLeftExpression()).getName()) || NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function2.getName())) && (function2.getParameters().getExpressions().size() == 2 || function2.getParameters().getExpressions().size() == 3) && StringValue.class.isInstance(function2.getParameters().getExpressions().get(1))) {
                Boolean rightExpressionValue = Boolean.valueOf(rightExpression);
                SqlUtils.isTrue(rightExpressionValue, "false is not allowed for regexMatch function");
                RegexFunction regexFunction = SqlUtils.getRegexFunction(function2, NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function2.getName()));
                return regexFunction;
            }
        } else if (net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression) && (REGEXMATCH_FUNCTION.equalsIgnoreCase((function = (net.sf.jsqlparser.expression.Function)incomingExpression).getName()) || NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function.getName())) && (function.getParameters().getExpressions().size() == 2 || function.getParameters().getExpressions().size() == 3) && StringValue.class.isInstance(function.getParameters().getExpressions().get(1))) {
            RegexFunction regexFunction = SqlUtils.getRegexFunction(function, NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function.getName()));
            return regexFunction;
        }
        return null;
    }

    private static RegexFunction getRegexFunction(net.sf.jsqlparser.expression.Function function, boolean isNot) throws ParseException {
        String column = SqlUtils.getStringValue(function.getParameters().getExpressions().get(0));
        String regex = SqlUtils.fixDoubleSingleQuotes(((StringValue)function.getParameters().getExpressions().get(1)).getValue());
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new ParseException(e.getMessage());
        }
        RegexFunction regexFunction = new RegexFunction(column, regex, isNot);
        if (function.getParameters().getExpressions().size() == 3 && StringValue.class.isInstance(function.getParameters().getExpressions().get(2))) {
            regexFunction.setOptions(((StringValue)function.getParameters().getExpressions().get(2)).getValue());
        }
        return regexFunction;
    }

    public static void isTrue(boolean expression, String message) throws ParseException {
        if (!expression) {
            throw new ParseException(message);
        }
    }

    public static void isFalse(boolean expression, String message) throws ParseException {
        if (expression) {
            throw new ParseException(message);
        }
    }

    public static boolean isColumn(Expression e) {
        return e instanceof Column && !((Column)e).getName(false).matches("^(\".*\"|true|false)$");
    }

    public static Column removeAliasFromColumn(Column c, String aliasBase) {
        c.setColumnName(c.getName(false).startsWith(aliasBase + ".") ? c.getName(false).substring(aliasBase.length() + 1) : c.getName(false));
        c.setTable(null);
        return c;
    }

    public static String getColumnNameFromColumn(Column c, String aliasBase) {
        return c.getName(false).startsWith(aliasBase + ".") ? c.getName(false).substring(aliasBase.length() + 1) : c.getName(false);
    }

    public static String getColumnNameFromColumn(Column c) {
        String[] splitedNestedField = c.getName(false).split("\\.");
        if (splitedNestedField.length > 2) {
            return String.join((CharSequence)".", Arrays.copyOfRange(splitedNestedField, 1, splitedNestedField.length));
        }
        return splitedNestedField[splitedNestedField.length - 1];
    }

    public static String getBaseAliasTable(Column c) {
        String[] splitedNestedField = c.getName(false).split("\\.");
        return splitedNestedField[0];
    }

    public static boolean isTableAliasOfColumn(Column column, String tableAlias) {
        String columnName = column.getName(false);
        return columnName.startsWith(tableAlias);
    }

    public static void updateJoinType(Join j) {
        if (j.toString().toLowerCase().startsWith("join ")) {
            j.setInner(true);
        }
    }

    public static boolean isAggregateExp(String field) {
        String fieldForAgg = field.trim().toLowerCase();
        return fieldForAgg.startsWith("sum(") || fieldForAgg.startsWith("avg(") || fieldForAgg.startsWith("min(") || fieldForAgg.startsWith("max(") || fieldForAgg.startsWith("count(");
    }

    public static String generateAggField(net.sf.jsqlparser.expression.Function f, Alias alias) throws ParseException {
        String aliasStr = alias == null ? null : alias.getName();
        return SqlUtils.generateAggField(f, aliasStr);
    }

    public static String generateAggField(net.sf.jsqlparser.expression.Function f, String alias) throws ParseException {
        String field = SqlUtils.getFieldFromFunction(f);
        String function = f.getName().toLowerCase();
        if ("*".equals(field) || function.equals("count")) {
            return alias == null ? function : alias;
        }
        return alias == null ? function + "_" + field.replaceAll("\\.", "_") : alias;
    }

    public static String getFieldFromFunction(net.sf.jsqlparser.expression.Function function) throws ParseException {
        List parameters;
        List<Object> list = parameters = function.getParameters() == null ? Collections.emptyList() : Lists.transform(function.getParameters().getExpressions(), new Function<Expression, String>(){

            @Override
            public String apply(@Nonnull Expression expression) {
                return SqlUtils.getStringValue(expression);
            }
        });
        if (parameters.size() > 1) {
            throw new ParseException(function.getName() + " function can only have one parameter");
        }
        return parameters.size() > 0 ? (String)Iterables.get(parameters, 0) : null;
    }

    public static Object nonFunctionToNode(Expression exp) throws ParseException {
        return SqlUtils.isColumn(exp) && !exp.toString().startsWith("$") ? "$" + exp : SqlUtils.getValue(exp, null, FieldType.UNKNOWN, null);
    }

    public static boolean isTotalGroup(List<SelectItem> selectItems) {
        for (SelectItem sitem : selectItems) {
            if (!SqlUtils.isAggregateExp(sitem.toString())) continue;
            return true;
        }
        return false;
    }

    public static Expression cloneExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        try {
            return CCJSqlParserUtil.parseCondExpression(expression.toString());
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            return null;
        }
    }
}

