/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.util;

import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import org.bson.Document;
import org.bson.types.ObjectId;

public class ObjectIdFunction {
    private final Object value;
    private final String column;
    private final Expression comparisonExpression;

    public ObjectIdFunction(String column, Object value, Expression expression) throws ParseException {
        this.column = column;
        this.value = value;
        this.comparisonExpression = expression;
    }

    public String getColumn() {
        return this.column;
    }

    public Object toDocument() throws ParseException {
        if (EqualsTo.class.isInstance(this.comparisonExpression)) {
            return new ObjectId(this.value.toString());
        }
        if (NotEqualsTo.class.isInstance(this.comparisonExpression)) {
            return new Document("$ne", new ObjectId(this.value.toString()));
        }
        if (InExpression.class.isInstance(this.comparisonExpression)) {
            InExpression inExpression = (InExpression)this.comparisonExpression;
            List stringList = (List)this.value;
            return new Document(inExpression.isNot() ? "$nin" : "$in", Lists.transform(stringList, new Function<String, ObjectId>(){

                @Override
                public ObjectId apply(String s) {
                    return new ObjectId(s);
                }
            }));
        }
        throw new ParseException("Count not convert ObjectId function into document");
    }
}

