/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.processor;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.FunctionProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.DateFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.ObjectIdFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.RegexFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.bson.Document;

public class WhereCauseProcessor {
    private final FieldType defaultFieldType;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;

    public WhereCauseProcessor(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
        this.defaultFieldType = defaultFieldType;
        this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
    }

    private void parseComparativeExpr(Document query, Expression leftExpression, Expression rightExpression, String comparatorType) throws ParseException {
        String operator = "$" + comparatorType;
        if (net.sf.jsqlparser.expression.Function.class.isInstance(leftExpression)) {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            Object rightParse = this.parseExpression(new Document(), rightExpression, leftExpression);
            doc.put(operator, (Object)Arrays.asList(leftParse, SqlUtils.isColumn(rightExpression) && !rightExpression.toString().startsWith("$") ? "$" + rightParse : rightParse));
            query.put("$expr", (Object)doc);
        } else if (SqlUtils.isColumn(leftExpression) && SqlUtils.isColumn(rightExpression)) {
            Document doc = new Document();
            String leftName = ((Column)leftExpression).getName(false);
            String rightName = ((Column)rightExpression).getName(false);
            doc.put(operator, (Object)Arrays.asList(leftName.startsWith("$") ? leftName : "$" + leftName, rightName.startsWith("$") ? rightName : "$" + rightName));
            query.put("$expr", (Object)doc);
        } else if (net.sf.jsqlparser.expression.Function.class.isInstance(rightExpression)) {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), rightExpression, leftExpression);
            Object rightParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            doc.put(operator, (Object)Arrays.asList(leftParse, SqlUtils.isColumn(leftExpression) && !leftExpression.toString().startsWith("$") ? "$" + rightParse : rightParse));
            query.put("$expr", (Object)doc);
        } else if (SqlUtils.isColumn(leftExpression)) {
            Document subdocument = new Document();
            if (operator.equals("$eq")) {
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), this.parseExpression(new Document(), rightExpression, leftExpression));
            } else {
                subdocument.put(operator, this.parseExpression(new Document(), rightExpression, leftExpression));
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), (Object)subdocument);
            }
        } else {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            doc.put(operator, (Object)Arrays.asList(leftParse, SqlUtils.nonFunctionToNode(rightExpression)));
            query.put("$expr", (Object)doc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parseExpression(Document query, Expression incomingExpression, Expression otherSide) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            RegexFunction regexFunction = SqlUtils.isRegexFunction(incomingExpression);
            DateFunction dateFunction = SqlUtils.isDateFunction(incomingExpression);
            ObjectIdFunction objectIdFunction = SqlUtils.isObjectIdFunction(this, incomingExpression);
            if (regexFunction != null) {
                Document regexDocument = new Document("$regex", regexFunction.getRegex());
                if (regexFunction.getOptions() != null) {
                    regexDocument.append("$options", regexFunction.getOptions());
                }
                query.put(regexFunction.getColumn(), this.wrapIfIsNot(regexDocument, regexFunction));
                return query;
            } else if (dateFunction != null) {
                query.put(dateFunction.getColumn(), (Object)new Document(dateFunction.getComparisonExpression(), dateFunction.getDate()));
                return query;
            } else if (objectIdFunction != null) {
                query.put(objectIdFunction.getColumn(), objectIdFunction.toDocument());
                return query;
            } else if (EqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((EqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((EqualsTo)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "eq");
                return query;
            } else if (NotEqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((NotEqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((NotEqualsTo)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "ne");
                return query;
            } else if (GreaterThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThan)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "gt");
                return query;
            } else if (MinorThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((MinorThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((MinorThan)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "lt");
                return query;
            } else if (GreaterThanEquals.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThanEquals)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThanEquals)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "gte");
                return query;
            } else {
                if (!MinorThanEquals.class.isInstance(incomingExpression)) return query;
                Expression leftExpression = ((MinorThanEquals)incomingExpression).getLeftExpression();
                Expression rightExpression = ((MinorThanEquals)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "lte");
            }
            return query;
        } else if (LikeExpression.class.isInstance(incomingExpression) && Column.class.isInstance(((LikeExpression)incomingExpression).getLeftExpression()) && (StringValue.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()) || Column.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()))) {
            LikeExpression likeExpression = (LikeExpression)incomingExpression;
            String stringValueLeftSide = SqlUtils.getStringValue(likeExpression.getLeftExpression());
            String stringValueRightSide = SqlUtils.getStringValue(likeExpression.getRightExpression());
            String convertedRegexString = "^" + SqlUtils.replaceRegexCharacters(stringValueRightSide) + "$";
            Document document = new Document("$regex", convertedRegexString);
            document = likeExpression.isNot() ? new Document(stringValueLeftSide, new Document("$not", Pattern.compile(convertedRegexString))) : new Document(stringValueLeftSide, document);
            query.putAll(document);
            return query;
        } else if (IsNullExpression.class.isInstance(incomingExpression)) {
            IsNullExpression isNullExpression = (IsNullExpression)incomingExpression;
            query.put(SqlUtils.getStringValue(isNullExpression.getLeftExpression()), (Object)new Document("$exists", isNullExpression.isNot()));
            return query;
        } else if (InExpression.class.isInstance(incomingExpression)) {
            InExpression inExpression = (InExpression)incomingExpression;
            final Expression leftExpression = ((InExpression)incomingExpression).getLeftExpression();
            String leftExpressionAsString = SqlUtils.getStringValue(leftExpression);
            ObjectIdFunction objectIdFunction = SqlUtils.isObjectIdFunction(this, incomingExpression);
            if (objectIdFunction != null) {
                query.put(objectIdFunction.getColumn(), objectIdFunction.toDocument());
                return query;
            } else {
                List<Object> objectList = Lists.transform(((ExpressionList)inExpression.getRightItemsList()).getExpressions(), new Function<Expression, Object>(){

                    @Override
                    public Object apply(Expression expression) {
                        try {
                            return WhereCauseProcessor.this.parseExpression(new Document(), expression, leftExpression);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                if (net.sf.jsqlparser.expression.Function.class.isInstance(leftExpression)) {
                    String mongoInFunction = inExpression.isNot() ? "$fnin" : "$fin";
                    query.put(mongoInFunction, (Object)new Document("function", this.parseExpression(new Document(), leftExpression, otherSide)).append("list", objectList));
                    return query;
                } else {
                    String mongoInFunction = inExpression.isNot() ? "$nin" : "$in";
                    Document doc = new Document();
                    List<Object> lobj = Arrays.asList(SqlUtils.nonFunctionToNode(leftExpression), objectList);
                    doc.put(mongoInFunction, (Object)lobj);
                    query.put("$expr", (Object)doc);
                }
            }
            return query;
        } else if (AndExpression.class.isInstance(incomingExpression)) {
            this.handleAndOr("$and", (BinaryExpression)incomingExpression, query);
            return query;
        } else if (OrExpression.class.isInstance(incomingExpression)) {
            this.handleAndOr("$or", (BinaryExpression)incomingExpression, query);
            return query;
        } else {
            if (Parenthesis.class.isInstance(incomingExpression)) {
                Parenthesis parenthesis = (Parenthesis)incomingExpression;
                return this.parseExpression(new Document(), parenthesis.getExpression(), null);
            }
            if (NotExpression.class.isInstance(incomingExpression)) {
                Expression expression = ((NotExpression)incomingExpression).getExpression();
                if (!Parenthesis.class.isInstance(expression)) return new Document(SqlUtils.getStringValue(expression), new Document("$ne", true));
                return new Document("$nor", Arrays.asList(this.parseExpression(query, expression, otherSide)));
            }
            if (net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression)) {
                net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)incomingExpression;
                RegexFunction regexFunction = SqlUtils.isRegexFunction(incomingExpression);
                if (regexFunction == null) return this.recurseFunctions(query, function, this.defaultFieldType, this.fieldNameToFieldTypeMapping);
                Document regexDocument = new Document("$regex", regexFunction.getRegex());
                if (regexFunction.getOptions() != null) {
                    regexDocument.append("$options", regexFunction.getOptions());
                }
                query.put(regexFunction.getColumn(), this.wrapIfIsNot(regexDocument, regexFunction));
                return query;
            } else {
                if (otherSide != null) return SqlUtils.getValue(incomingExpression, otherSide, this.defaultFieldType, this.fieldNameToFieldTypeMapping);
                return new Document(SqlUtils.getStringValue(incomingExpression), true);
            }
        }
    }

    private Object wrapIfIsNot(Document regexDocument, RegexFunction regexFunction) {
        if (regexFunction.isNot()) {
            if (regexFunction.getOptions() != null) {
                throw new IllegalArgumentException("$not regex not supported with options");
            }
            return new Document("$not", Pattern.compile(regexFunction.getRegex()));
        }
        return regexDocument;
    }

    protected Object recurseFunctions(Document query, Object object, FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) throws ParseException {
        if (net.sf.jsqlparser.expression.Function.class.isInstance(object)) {
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)object;
            query.put("$" + FunctionProcessor.transcriptFunctionName(function.getName()), this.recurseFunctions(new Document(), function.getParameters(), defaultFieldType, fieldNameToFieldTypeMapping));
        } else {
            if (ExpressionList.class.isInstance(object)) {
                ExpressionList expressionList = (ExpressionList)object;
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (Expression expression : expressionList.getExpressions()) {
                    objectList.add(this.recurseFunctions(new Document(), expression, defaultFieldType, fieldNameToFieldTypeMapping));
                }
                return objectList.size() == 1 ? objectList.get(0) : objectList;
            }
            if (Expression.class.isInstance(object)) {
                return SqlUtils.getValue((Expression)object, null, defaultFieldType, fieldNameToFieldTypeMapping);
            }
        }
        return query.isEmpty() ? null : query;
    }

    private void handleAndOr(String key, BinaryExpression incomingExpression, Document query) throws ParseException {
        Expression rightExpression;
        Expression leftExpression = incomingExpression.getLeftExpression();
        List result = this.flattenOrsOrAnds(new ArrayList(), leftExpression, leftExpression, rightExpression = incomingExpression.getRightExpression());
        if (result != null) {
            query.put(key, (Object)Lists.reverse(result));
        } else {
            query.put(key, (Object)Arrays.asList(this.parseExpression(new Document(), leftExpression, rightExpression), this.parseExpression(new Document(), rightExpression, leftExpression)));
        }
    }

    private List flattenOrsOrAnds(List arrayList, Expression firstExpression, Expression leftExpression, Expression rightExpression) throws ParseException {
        if (firstExpression.getClass().isInstance(leftExpression) && this.isOrAndExpression(leftExpression) && !this.isOrAndExpression(rightExpression)) {
            Expression left = ((BinaryExpression)leftExpression).getLeftExpression();
            Expression right = ((BinaryExpression)leftExpression).getRightExpression();
            arrayList.add(this.parseExpression(new Document(), rightExpression, null));
            List result = this.flattenOrsOrAnds(arrayList, firstExpression, left, right);
            if (result != null) {
                return arrayList;
            }
        } else {
            if (this.isOrAndExpression(firstExpression) && !this.isOrAndExpression(leftExpression) && !this.isOrAndExpression(rightExpression)) {
                arrayList.add(this.parseExpression(new Document(), rightExpression, null));
                arrayList.add(this.parseExpression(new Document(), leftExpression, null));
                return arrayList;
            }
            return null;
        }
        return null;
    }

    private boolean isOrAndExpression(Expression expression) {
        return OrExpression.class.isInstance(expression) || AndExpression.class.isInstance(expression);
    }
}

