/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.holder.from;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandType;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.AliasHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.FromHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.ExpVisitorEraseAliasTableBaseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;

public class SQLCommandInfoHolder
implements SQLInfoHolder {
    private final SQLCommandType sqlCommandType;
    private final boolean isDistinct;
    private final boolean isCountAll;
    private final boolean isTotalGroup;
    private final FromHolder from;
    private final long limit;
    private final long offset;
    private final Expression whereClause;
    private final List<SelectItem> selectItems;
    private final List<Join> joins;
    private final List<String> groupBys;
    private final List<OrderByElement> orderByElements;
    private final AliasHolder aliasHolder;
    private final Expression havingClause;

    public SQLCommandInfoHolder(SQLCommandType sqlCommandType, Expression whereClause, boolean isDistinct, boolean isCountAll, boolean isTotalGroup, FromHolder from, long limit, long offset, List<SelectItem> selectItems, List<Join> joins, List<String> groupBys, List<OrderByElement> orderByElements, AliasHolder aliasHolder, Expression havingClause) {
        this.sqlCommandType = sqlCommandType;
        this.whereClause = whereClause;
        this.isDistinct = isDistinct;
        this.isCountAll = isCountAll;
        this.isTotalGroup = isTotalGroup;
        this.from = from;
        this.limit = limit;
        this.offset = offset;
        this.selectItems = selectItems;
        this.joins = joins;
        this.groupBys = groupBys;
        this.havingClause = havingClause;
        this.orderByElements = orderByElements;
        this.aliasHolder = aliasHolder;
    }

    @Override
    public String getBaseTableName() throws net.sf.jsqlparser.parser.ParseException {
        return this.from.getBaseFromTableName();
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public boolean isCountAll() {
        return this.isCountAll;
    }

    public boolean isTotalGroup() {
        return this.isTotalGroup;
    }

    public String getTable() throws net.sf.jsqlparser.parser.ParseException {
        return this.from.getBaseFromTableName();
    }

    public FromHolder getFromHolder() {
        return this.from;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<String> getGoupBys() {
        return this.groupBys;
    }

    public Expression getHavingClause() {
        return this.havingClause;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public SQLCommandType getSqlCommandType() {
        return this.sqlCommandType;
    }

    public AliasHolder getAliasHolder() {
        return this.aliasHolder;
    }

    public static class Builder {
        private final FieldType defaultFieldType;
        private final Map<String, FieldType> fieldNameToFieldTypeMapping;
        private SQLCommandType sqlCommandType;
        private Expression whereClause;
        private boolean isDistinct = false;
        private boolean isCountAll = false;
        private boolean isTotalGroup = false;
        private FromHolder from;
        private long limit = -1L;
        private long offset = -1L;
        private List<SelectItem> selectItems = new ArrayList<SelectItem>();
        private List<Join> joins = new ArrayList<Join>();
        private List<String> groupBys = new ArrayList<String>();
        private Expression havingClause;
        private List<OrderByElement> orderByElements1 = new ArrayList<OrderByElement>();
        private AliasHolder aliasHolder;

        private Builder(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
            this.defaultFieldType = defaultFieldType;
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
        }

        private FromHolder generateFromHolder(FromHolder tholder, FromItem fromItem, List<Join> ljoin) throws net.sf.jsqlparser.parser.ParseException, ParseException {
            Alias alias = fromItem.getAlias();
            tholder.addFrom(fromItem, alias != null ? alias.getName() : null);
            if (ljoin != null) {
                for (Join j : ljoin) {
                    SqlUtils.updateJoinType(j);
                    if (j.isInner() || j.isLeft()) {
                        tholder = this.generateFromHolder(tholder, j.getRightItem(), null);
                        continue;
                    }
                    throw new net.sf.jsqlparser.parser.ParseException("Join type not suported");
                }
            }
            return tholder;
        }

        public Builder setJSqlParser(CCJSqlParser jSqlParser) throws ParseException, net.sf.jsqlparser.parser.ParseException {
            Statement statement = jSqlParser.Statement();
            return this.setStatement(statement);
        }

        public Builder setStatement(Statement statement) throws ParseException, net.sf.jsqlparser.parser.ParseException {
            if (Select.class.isAssignableFrom(statement.getClass())) {
                this.sqlCommandType = SQLCommandType.SELECT;
                SelectBody selectBody = ((Select)statement).getSelectBody();
                if (SetOperationList.class.isInstance(selectBody)) {
                    SetOperationList setOperationList = (SetOperationList)selectBody;
                    if (setOperationList.getSelects() != null && setOperationList.getSelects().size() == 1 && PlainSelect.class.isInstance(setOperationList.getSelects().get(0))) {
                        return this.setPlainSelect((PlainSelect)setOperationList.getSelects().get(0));
                    }
                } else if (PlainSelect.class.isInstance(selectBody)) {
                    return this.setPlainSelect((PlainSelect)selectBody);
                }
                throw new net.sf.jsqlparser.parser.ParseException("No supported sentence");
            }
            if (Delete.class.isAssignableFrom(statement.getClass())) {
                this.sqlCommandType = SQLCommandType.DELETE;
                Delete delete = (Delete)statement;
                return this.setDelete(delete);
            }
            throw new net.sf.jsqlparser.parser.ParseException("No supported sentence");
        }

        public Builder setPlainSelect(PlainSelect plainSelect) throws ParseException, net.sf.jsqlparser.parser.ParseException {
            SqlUtils.isTrue(plainSelect != null, "could not parseNaturalLanguageDate SELECT statement from query");
            SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
            this.whereClause = plainSelect.getWhere();
            this.isDistinct = plainSelect.getDistinct() != null;
            this.isCountAll = SqlUtils.isCountAll(plainSelect.getSelectItems());
            SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
            this.from = this.generateFromHolder(new FromHolder(this.defaultFieldType, this.fieldNameToFieldTypeMapping), plainSelect.getFromItem(), plainSelect.getJoins());
            this.limit = SqlUtils.getLimit(plainSelect.getLimit());
            this.offset = SqlUtils.getOffset(plainSelect.getOffset());
            this.orderByElements1 = plainSelect.getOrderByElements();
            this.selectItems = plainSelect.getSelectItems();
            this.joins = plainSelect.getJoins();
            this.groupBys = SqlUtils.getGroupByColumnReferences(plainSelect);
            this.havingClause = plainSelect.getHaving();
            this.aliasHolder = this.generateHashAliasFromSelectItems(this.selectItems);
            this.isTotalGroup = SqlUtils.isTotalGroup(this.selectItems);
            SqlUtils.isTrue(plainSelect.getFromItem() != null, "could not find table to query.  Only one simple table name is supported.");
            return this;
        }

        public Builder setDelete(Delete delete) throws ParseException, net.sf.jsqlparser.parser.ParseException {
            SqlUtils.isTrue(delete.getTables().size() == 0, "there should only be on table specified for deletes");
            this.from = this.generateFromHolder(new FromHolder(this.defaultFieldType, this.fieldNameToFieldTypeMapping), delete.getTable(), null);
            this.whereClause = delete.getWhere();
            return this;
        }

        private AliasHolder generateHashAliasFromSelectItems(List<SelectItem> selectItems) {
            HashMap<String, String> aliasFromFieldHash = new HashMap<String, String>();
            HashMap<String, String> fieldFromAliasHash = new HashMap<String, String>();
            for (SelectItem sitem : selectItems) {
                SelectExpressionItem seitem;
                if (sitem instanceof AllColumns || !(sitem instanceof SelectExpressionItem) || (seitem = (SelectExpressionItem)sitem).getAlias() == null) continue;
                Expression selectExp = seitem.getExpression();
                selectExp.accept(new ExpVisitorEraseAliasTableBaseBuilder(this.from.getBaseAliasTable()));
                String expStr = selectExp.toString();
                String aliasStr = seitem.getAlias().getName();
                aliasFromFieldHash.put(expStr, aliasStr);
                fieldFromAliasHash.put(aliasStr, expStr);
            }
            return new AliasHolder(aliasFromFieldHash, fieldFromAliasHash);
        }

        public SQLCommandInfoHolder build() {
            return new SQLCommandInfoHolder(this.sqlCommandType, this.whereClause, this.isDistinct, this.isCountAll, this.isTotalGroup, this.from, this.limit, this.offset, this.selectItems, this.joins, this.groupBys, this.orderByElements1, this.aliasHolder, this.havingClause);
        }

        public static Builder create(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
            return new Builder(defaultFieldType, fieldNameToFieldTypeMapping);
        }
    }
}

