/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.MongoDBQueryHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryResultIterator;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandType;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.AliasHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.ExpressionHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.FromHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLCommandInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.HavingCauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.JoinProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.WhereCauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.ExpVisitorEraseAliasTableBaseBuilder;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.WhereVisitorMatchAndLookupPipelineMatchBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.StreamProvider;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public class QueryConverter {
    private final CCJSqlParser jSqlParser;
    private final Integer aggregationBatchSize;
    private final Boolean aggregationAllowDiskUse;
    private MongoDBQueryHolder mongoDBQueryHolder;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;
    private final FieldType defaultFieldType;
    private SQLCommandInfoHolder sqlCommandInfoHolder;
    private static final JsonWriterSettings relaxed = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();

    @Deprecated
    public QueryConverter() throws ParseException {
        this.fieldNameToFieldTypeMapping = Collections.emptyMap();
        this.defaultFieldType = FieldType.UNKNOWN;
        this.sqlCommandInfoHolder = null;
        this.mongoDBQueryHolder = null;
        this.jSqlParser = null;
        this.aggregationBatchSize = null;
        this.aggregationAllowDiskUse = null;
    }

    @Deprecated
    public QueryConverter(String sql) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), Collections.emptyMap(), FieldType.UNKNOWN);
    }

    @Deprecated
    public QueryConverter(String sql, Map<String, FieldType> fieldNameToFieldTypeMapping) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), fieldNameToFieldTypeMapping, FieldType.UNKNOWN);
    }

    @Deprecated
    public QueryConverter(String sql, FieldType fieldType) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), Collections.emptyMap(), fieldType);
    }

    @Deprecated
    public QueryConverter(String sql, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType) throws ParseException {
        this(new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8)), fieldNameToFieldTypeMapping, defaultFieldType);
    }

    @Deprecated
    public QueryConverter(InputStream inputStream) throws ParseException {
        this(inputStream, Collections.emptyMap(), FieldType.UNKNOWN);
    }

    @Deprecated
    public QueryConverter(InputStream inputStream, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType) throws ParseException {
        this(inputStream, fieldNameToFieldTypeMapping, defaultFieldType, false, -1);
    }

    @Deprecated
    public QueryConverter(InputStream inputStream, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType, Boolean aggregationAllowDiskUse, Integer aggregationBatchSize) throws ParseException {
        try {
            this.aggregationAllowDiskUse = aggregationAllowDiskUse;
            this.aggregationBatchSize = aggregationBatchSize;
            this.jSqlParser = new CCJSqlParser(new StreamProvider(inputStream, Charsets.UTF_8.name()));
            this.defaultFieldType = defaultFieldType != null ? defaultFieldType : FieldType.UNKNOWN;
            this.sqlCommandInfoHolder = SQLCommandInfoHolder.Builder.create(defaultFieldType, fieldNameToFieldTypeMapping).setJSqlParser(this.jSqlParser).build();
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping != null ? fieldNameToFieldTypeMapping : Collections.emptyMap();
            Token nextToken = this.jSqlParser.getNextToken();
            SqlUtils.isTrue(StringUtils.isEmpty(nextToken.image) || ";".equals(nextToken.image), "unable to parse complete sql string. one reason for this is the use of double equals (==)");
            this.mongoDBQueryHolder = this.getMongoQueryInternal(this.sqlCommandInfoHolder);
            this.validate();
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        catch (net.sf.jsqlparser.parser.ParseException e) {
            throw SqlUtils.convertParseException(e);
        }
    }

    private void validate() throws ParseException {
        List<SelectItem> selectItems = this.sqlCommandInfoHolder.getSelectItems();
        ArrayList<SelectItem> filteredItems = Lists.newArrayList(Iterables.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && Column.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        SqlUtils.isFalse((selectItems.size() > 1 || SqlUtils.isSelectAll(selectItems)) && this.sqlCommandInfoHolder.isDistinct(), "cannot run distinct one more than one column");
        SqlUtils.isFalse(this.sqlCommandInfoHolder.getGoupBys().size() == 0 && selectItems.size() != filteredItems.size() && !SqlUtils.isSelectAll(selectItems) && !SqlUtils.isCountAll(selectItems) && !this.sqlCommandInfoHolder.isTotalGroup(), "illegal expression(s) found in select clause.  Only column names supported");
    }

    public MongoDBQueryHolder getMongoQuery() {
        return this.mongoDBQueryHolder;
    }

    public List<Document> fromSQLCommandInfoHolderToAggregateSteps(SQLCommandInfoHolder sqlCommandInfoHolder) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        MongoDBQueryHolder mqueryHolder = this.getMongoQueryInternal(sqlCommandInfoHolder);
        return this.generateAggSteps(mqueryHolder, sqlCommandInfoHolder);
    }

    private MongoDBQueryHolder getMongoQueryInternal(SQLCommandInfoHolder sqlCommandInfoHolder) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        MongoDBQueryHolder mongoDBQueryHolder = new MongoDBQueryHolder(sqlCommandInfoHolder.getBaseTableName(), sqlCommandInfoHolder.getSqlCommandType());
        Document document = new Document();
        if (sqlCommandInfoHolder.getFromHolder().getBaseFrom().getClass() == SubSelect.class) {
            mongoDBQueryHolder.setPrevSteps(this.fromSQLCommandInfoHolderToAggregateSteps((SQLCommandInfoHolder)sqlCommandInfoHolder.getFromHolder().getBaseSQLHolder()));
        }
        if (sqlCommandInfoHolder.isDistinct()) {
            document.put(sqlCommandInfoHolder.getSelectItems().get(0).toString(), (Object)1);
            mongoDBQueryHolder.setProjection(document);
            mongoDBQueryHolder.setDistinct(sqlCommandInfoHolder.isDistinct());
        } else if (sqlCommandInfoHolder.getGoupBys().size() > 0) {
            List<String> groupBys = this.preprocessGroupBy(sqlCommandInfoHolder.getGoupBys(), sqlCommandInfoHolder.getFromHolder());
            List<SelectItem> selects = this.preprocessSelect(sqlCommandInfoHolder.getSelectItems(), sqlCommandInfoHolder.getFromHolder());
            if (sqlCommandInfoHolder.getGoupBys().size() > 0) {
                mongoDBQueryHolder.setGroupBys(groupBys);
            }
            mongoDBQueryHolder.setProjection(this.createProjectionsFromSelectItems(selects, groupBys));
            mongoDBQueryHolder.setAliasProjection(this.createAliasProjectionForGroupItems(selects, groupBys));
        } else if (sqlCommandInfoHolder.isTotalGroup()) {
            List<SelectItem> selects = this.preprocessSelect(sqlCommandInfoHolder.getSelectItems(), sqlCommandInfoHolder.getFromHolder());
            Document d = this.createProjectionsFromSelectItems(selects, null);
            mongoDBQueryHolder.setProjection(d);
            mongoDBQueryHolder.setAliasProjection(this.createAliasProjectionForGroupItems(selects, null));
        } else if (!SqlUtils.isSelectAll(sqlCommandInfoHolder.getSelectItems())) {
            document.put("_id", (Object)0);
            for (SelectItem selectItem : sqlCommandInfoHolder.getSelectItems()) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                if (selectExpressionItem.getExpression() instanceof Column) {
                    Column c = (Column)selectExpressionItem.getExpression();
                    String columnName = SqlUtils.removeAliasFromColumn(c, sqlCommandInfoHolder.getFromHolder().getBaseAliasTable()).getColumnName();
                    Alias alias = selectExpressionItem.getAlias();
                    document.put(alias != null ? alias.getName() : columnName, alias != null ? "$" + columnName : Integer.valueOf(1));
                    continue;
                }
                if (selectExpressionItem.getExpression() instanceof SubSelect) {
                    throw new ParseException("Unsupported subselect expression");
                }
                throw new ParseException("Unsupported project expression");
            }
            mongoDBQueryHolder.setProjection(document);
        }
        if (sqlCommandInfoHolder.isCountAll()) {
            mongoDBQueryHolder.setCountAll(sqlCommandInfoHolder.isCountAll());
        }
        if (sqlCommandInfoHolder.getJoins() != null) {
            mongoDBQueryHolder.setJoinPipeline(JoinProcessor.toPipelineSteps(this, sqlCommandInfoHolder.getFromHolder(), sqlCommandInfoHolder.getJoins(), SqlUtils.cloneExpression(sqlCommandInfoHolder.getWhereClause())));
        }
        if (sqlCommandInfoHolder.getOrderByElements() != null && sqlCommandInfoHolder.getOrderByElements().size() > 0) {
            mongoDBQueryHolder.setSort(this.createSortInfoFromOrderByElements(this.preprocessOrderBy(sqlCommandInfoHolder.getOrderByElements(), sqlCommandInfoHolder.getFromHolder()), sqlCommandInfoHolder.getAliasHolder(), sqlCommandInfoHolder.getGoupBys()));
        }
        if (sqlCommandInfoHolder.getWhereClause() != null) {
            WhereCauseProcessor whereCauseProcessor = new WhereCauseProcessor(this.defaultFieldType, this.fieldNameToFieldTypeMapping);
            Expression preprocessedWhere = this.preprocessWhere(sqlCommandInfoHolder.getWhereClause(), sqlCommandInfoHolder.getFromHolder());
            if (preprocessedWhere != null) {
                mongoDBQueryHolder.setQuery((Document)whereCauseProcessor.parseExpression(new Document(), preprocessedWhere, null));
            }
        }
        if (sqlCommandInfoHolder.getHavingClause() != null) {
            HavingCauseProcessor havingClauseProcessor = new HavingCauseProcessor(this.defaultFieldType, this.fieldNameToFieldTypeMapping);
            havingClauseProcessor.setAliasHolder(sqlCommandInfoHolder.getAliasHolder());
            mongoDBQueryHolder.setHaving((Document)havingClauseProcessor.parseExpression(new Document(), sqlCommandInfoHolder.getHavingClause(), null));
        }
        mongoDBQueryHolder.setOffset(sqlCommandInfoHolder.getOffset());
        mongoDBQueryHolder.setLimit(sqlCommandInfoHolder.getLimit());
        return mongoDBQueryHolder;
    }

    private Expression preprocessWhere(Expression exp, FromHolder tholder) {
        if (this.sqlCommandInfoHolder.getJoins() != null && !this.sqlCommandInfoHolder.getJoins().isEmpty()) {
            ExpressionHolder partialWhereExpHolder = new ExpressionHolder(null);
            MutableBoolean haveOrExpression = new MutableBoolean(false);
            exp.accept(new WhereVisitorMatchAndLookupPipelineMatchBuilder(tholder.getBaseAliasTable(), partialWhereExpHolder, haveOrExpression));
            if (haveOrExpression.booleanValue()) {
                return null;
            }
            exp = partialWhereExpHolder.getExpression();
        }
        if (exp != null) {
            exp.accept(new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return exp;
    }

    private List<OrderByElement> preprocessOrderBy(List<OrderByElement> lord, FromHolder tholder) {
        for (OrderByElement ord : lord) {
            ord.getExpression().accept(new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return lord;
    }

    private List<SelectItem> preprocessSelect(List<SelectItem> lsel, FromHolder tholder) {
        for (SelectItem sel : lsel) {
            sel.accept(new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return lsel;
    }

    private List<String> preprocessGroupBy(List<String> lgroup, FromHolder tholder) {
        LinkedList<String> lgroupEraseAlias = new LinkedList<String>();
        for (String group : lgroup) {
            int index = group.indexOf(tholder.getBaseAliasTable() + ".");
            if (index != -1) {
                lgroupEraseAlias.add(group.substring(tholder.getBaseAliasTable().length() + 1));
                continue;
            }
            lgroupEraseAlias.add(group);
        }
        return lgroupEraseAlias;
    }

    private Document createSortInfoFromOrderByElements(@Nonnull List<OrderByElement> orderByElements, AliasHolder aliasHolder, List<String> groupBys) throws ParseException {
        if (orderByElements.size() == 0) {
            return new Document();
        }
        final ArrayList<OrderByElement> functionItems = Lists.newArrayList(Iterables.filter(orderByElements, new Predicate<OrderByElement>(){

            @Override
            public boolean apply(@Nonnull OrderByElement orderByElement) {
                try {
                    if (net.sf.jsqlparser.expression.Function.class.isInstance(orderByElement.getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        ArrayList<OrderByElement> nonFunctionItems = Lists.newArrayList(Collections2.filter(orderByElements, new Predicate<OrderByElement>(){

            @Override
            public boolean apply(@Nonnull OrderByElement orderByElement) {
                return !functionItems.contains(orderByElement);
            }
        }));
        Document sortItems = new Document();
        for (OrderByElement orderByElement : orderByElements) {
            String sortKey;
            if (nonFunctionItems.contains(orderByElement)) {
                String sortField = SqlUtils.getStringValue(orderByElement.getExpression());
                String projectField = aliasHolder.getFieldFromAliasOrField(sortField);
                if (!groupBys.isEmpty()) {
                    projectField = !SqlUtils.isAggregateExp(projectField) ? (groupBys.size() > 1 ? "_id." + projectField.replaceAll("\\.", "_") : "_id") : sortField;
                }
                sortItems.put(projectField, (Object)(orderByElement.isAsc() ? 1 : -1));
                continue;
            }
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)orderByElement.getExpression();
            String alias = aliasHolder.getAliasFromFieldExp(function.toString());
            if (alias != null && !alias.equals(function.toString())) {
                sortKey = alias;
            } else {
                Document parseFunctionDocument = new Document();
                this.parseFunctionForAggregation(function, parseFunctionDocument, Collections.emptyList(), null);
                sortKey = Iterables.get(parseFunctionDocument.keySet(), 0);
            }
            sortItems.put(sortKey, (Object)(orderByElement.isAsc() ? 1 : -1));
        }
        return sortItems;
    }

    private Document createProjectionsFromSelectItems(@Nonnull List<SelectItem> selectItems, List<String> groupBys) throws ParseException {
        Document document = new Document();
        if (selectItems.size() == 0) {
            return document;
        }
        final ArrayList<SelectItem> functionItems = Lists.newArrayList(Iterables.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public boolean apply(@Nonnull SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        ArrayList<SelectItem> nonFunctionItems = Lists.newArrayList(Collections2.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public boolean apply(@Nonnull SelectItem selectItem) {
                return !functionItems.contains(selectItem);
            }
        }));
        Document idDocument = new Document();
        for (SelectItem selectItem : nonFunctionItems) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            Column column = (Column)selectExpressionItem.getExpression();
            String columnName = SqlUtils.getStringValue(column);
            idDocument.put(columnName.replaceAll("\\.", "_"), (Object)("$" + columnName));
        }
        if (!idDocument.isEmpty()) {
            document.append("_id", idDocument.size() == 1 ? Iterables.get(idDocument.values(), 0) : idDocument);
        }
        for (SelectItem selectItem : functionItems) {
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)((SelectExpressionItem)selectItem).getExpression();
            this.parseFunctionForAggregation(function, document, groupBys, ((SelectExpressionItem)selectItem).getAlias());
        }
        return document;
    }

    private Document createAliasProjectionForGroupItems(List<SelectItem> selectItems, List<String> groupBys) throws ParseException {
        SelectExpressionItem selectExpressionItem;
        Document document = new Document();
        final ArrayList<SelectItem> functionItems = Lists.newArrayList(Iterables.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public boolean apply(@Nonnull SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }
        }));
        ArrayList<SelectItem> nonFunctionItems = Lists.newArrayList(Collections2.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public boolean apply(@Nonnull SelectItem selectItem) {
                return !functionItems.contains(selectItem);
            }
        }));
        if (nonFunctionItems.size() == 1) {
            SelectExpressionItem selectExpressionItem2 = (SelectExpressionItem)nonFunctionItems.get(0);
            Column column = (Column)selectExpressionItem2.getExpression();
            String columnName = SqlUtils.getStringValue(column);
            Alias alias = selectExpressionItem2.getAlias();
            String nameOrAlias = alias != null ? alias.getName() : columnName;
            document.put(nameOrAlias, (Object)"$_id");
        } else {
            for (SelectItem selectItem : nonFunctionItems) {
                selectExpressionItem = (SelectExpressionItem)selectItem;
                Column column = (Column)selectExpressionItem.getExpression();
                String columnName = SqlUtils.getStringValue(column);
                Alias alias = selectExpressionItem.getAlias();
                String nameOrAlias = alias != null ? alias.getName() : columnName;
                document.put(nameOrAlias, (Object)("$_id." + columnName.replaceAll("\\.", "_")));
            }
        }
        for (SelectItem selectItem : functionItems) {
            selectExpressionItem = (SelectExpressionItem)selectItem;
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)selectExpressionItem.getExpression();
            Alias alias = selectExpressionItem.getAlias();
            document.put(SqlUtils.generateAggField(function, alias), (Object)1);
        }
        document.put("_id", (Object)0);
        return document;
    }

    private void parseFunctionForAggregation(net.sf.jsqlparser.expression.Function function, Document document, List<String> groupBys, Alias alias) throws ParseException {
        String op = function.getName().toLowerCase();
        String aggField = SqlUtils.generateAggField(function, alias);
        switch (op) {
            case "count": {
                document.put(aggField, (Object)new Document("$sum", 1));
                break;
            }
            case "sum": 
            case "min": 
            case "max": 
            case "avg": {
                this.createFunction(op, aggField, document, "$" + SqlUtils.getFieldFromFunction(function));
                break;
            }
            default: {
                throw new ParseException("could not understand function:" + function.getName());
            }
        }
    }

    private void createFunction(String functionName, String aggField, Document document, Object value) throws ParseException {
        document.put(aggField, (Object)new Document("$" + functionName, value));
    }

    public void write(OutputStream outputStream) throws IOException {
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        boolean isFindQuery = false;
        if (mongoDBQueryHolder.isDistinct()) {
            IOUtils.write("db." + mongoDBQueryHolder.getCollection() + ".distinct(", outputStream);
            IOUtils.write("\"" + this.getDistinctFieldName(mongoDBQueryHolder) + "\"", outputStream);
            IOUtils.write(" , ", outputStream);
            IOUtils.write(this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson(relaxed)), outputStream);
        } else if (this.sqlCommandInfoHolder.isCountAll() && !this.isAggregate(mongoDBQueryHolder)) {
            IOUtils.write("db." + mongoDBQueryHolder.getCollection() + ".count(", outputStream);
            IOUtils.write(this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson(relaxed)), outputStream);
        } else if (this.isAggregate(mongoDBQueryHolder)) {
            IOUtils.write("db." + mongoDBQueryHolder.getCollection() + ".aggregate(", outputStream);
            IOUtils.write("[", outputStream);
            IOUtils.write(Joiner.on(",").join(Lists.transform(this.generateAggSteps(mongoDBQueryHolder, this.sqlCommandInfoHolder), new Function<Document, String>(){

                @Override
                public String apply(Document document) {
                    return QueryConverter.this.prettyPrintJson(document.toJson(relaxed));
                }
            })), outputStream);
            IOUtils.write("]", outputStream);
            Document options = new Document();
            if (this.aggregationAllowDiskUse != null) {
                options.put("allowDiskUse", (Object)this.aggregationAllowDiskUse);
            }
            if (this.aggregationBatchSize != null) {
                options.put("cursor", (Object)new Document("batchSize", this.aggregationBatchSize));
            }
            if (options.size() > 0) {
                IOUtils.write(",", outputStream);
                IOUtils.write(this.prettyPrintJson(options.toJson(relaxed)), outputStream);
            }
        } else {
            if (this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.SELECT) {
                isFindQuery = true;
                IOUtils.write("db." + mongoDBQueryHolder.getCollection() + ".find(", outputStream);
            } else if (this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.DELETE) {
                IOUtils.write("db." + mongoDBQueryHolder.getCollection() + ".remove(", outputStream);
            }
            IOUtils.write(this.prettyPrintJson(mongoDBQueryHolder.getQuery().toJson(relaxed)), outputStream);
            if (mongoDBQueryHolder.getProjection() != null && mongoDBQueryHolder.getProjection().size() > 0 && this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.SELECT) {
                IOUtils.write(" , ", outputStream);
                IOUtils.write(this.prettyPrintJson(mongoDBQueryHolder.getProjection().toJson(relaxed)), outputStream);
            }
        }
        IOUtils.write(")", outputStream);
        if (isFindQuery) {
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                IOUtils.write(".sort(", outputStream);
                IOUtils.write(this.prettyPrintJson(mongoDBQueryHolder.getSort().toJson(relaxed)), outputStream);
                IOUtils.write(")", outputStream);
            }
            if (mongoDBQueryHolder.getOffset() != -1L) {
                IOUtils.write(".skip(", outputStream);
                IOUtils.write(mongoDBQueryHolder.getOffset() + "", outputStream);
                IOUtils.write(")", outputStream);
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                IOUtils.write(".limit(", outputStream);
                IOUtils.write(mongoDBQueryHolder.getLimit() + "", outputStream);
                IOUtils.write(")", outputStream);
            }
        }
    }

    private boolean isAggregate(MongoDBQueryHolder mongoDBQueryHolder) {
        return this.sqlCommandInfoHolder.getAliasHolder() != null && !this.sqlCommandInfoHolder.getAliasHolder().isEmpty() || this.sqlCommandInfoHolder.getGoupBys().size() > 0 || this.sqlCommandInfoHolder.getJoins() != null && this.sqlCommandInfoHolder.getJoins().size() > 0 || mongoDBQueryHolder.getPrevSteps() != null && !mongoDBQueryHolder.getPrevSteps().isEmpty() || this.sqlCommandInfoHolder.isTotalGroup() && !SqlUtils.isCountAll(this.sqlCommandInfoHolder.getSelectItems());
    }

    private String getDistinctFieldName(MongoDBQueryHolder mongoDBQueryHolder) {
        return Iterables.get(mongoDBQueryHolder.getProjection().keySet(), 0);
    }

    public <T> T run(MongoDatabase mongoDatabase) throws ParseException {
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(mongoDBQueryHolder.getCollection());
        if (SQLCommandType.SELECT.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            if (mongoDBQueryHolder.isDistinct()) {
                return (T)new QueryResultIterator<String>(mongoCollection.distinct(this.getDistinctFieldName(mongoDBQueryHolder), mongoDBQueryHolder.getQuery(), String.class));
            }
            if (this.sqlCommandInfoHolder.isCountAll() && !this.isAggregate(mongoDBQueryHolder)) {
                return (T)Long.valueOf(mongoCollection.count(mongoDBQueryHolder.getQuery()));
            }
            if (this.isAggregate(mongoDBQueryHolder)) {
                AggregateIterable<Document> aggregate = mongoCollection.aggregate(this.generateAggSteps(mongoDBQueryHolder, this.sqlCommandInfoHolder));
                if (this.aggregationAllowDiskUse != null) {
                    aggregate.allowDiskUse(this.aggregationAllowDiskUse);
                }
                if (this.aggregationBatchSize != null) {
                    aggregate.batchSize(this.aggregationBatchSize);
                }
                return (T)new QueryResultIterator<Document>(aggregate);
            }
            FindIterable<Document> findIterable = mongoCollection.find(mongoDBQueryHolder.getQuery()).projection(mongoDBQueryHolder.getProjection());
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                findIterable.sort(mongoDBQueryHolder.getSort());
            }
            if (mongoDBQueryHolder.getOffset() != -1L) {
                findIterable.skip((int)mongoDBQueryHolder.getOffset());
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                findIterable.limit((int)mongoDBQueryHolder.getLimit());
            }
            return (T)new QueryResultIterator<Document>(findIterable);
        }
        if (SQLCommandType.DELETE.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            DeleteResult deleteResult = mongoCollection.deleteMany(mongoDBQueryHolder.getQuery());
            return (T)Long.valueOf(deleteResult.getDeletedCount());
        }
        throw new UnsupportedOperationException("SQL command type not supported");
    }

    private List<Document> setUpStartPipeline(MongoDBQueryHolder mongoDBQueryHolder) {
        List<Document> documents = mongoDBQueryHolder.getPrevSteps();
        if (documents == null || documents.isEmpty()) {
            documents = new LinkedList<Document>();
        }
        return documents;
    }

    public List<Document> generateAggSteps(MongoDBQueryHolder mongoDBQueryHolder, SQLCommandInfoHolder sqlCommandInfoHolder) {
        Document aliasProjection;
        List<Document> documents = this.setUpStartPipeline(mongoDBQueryHolder);
        if (mongoDBQueryHolder.getQuery() != null && mongoDBQueryHolder.getQuery().size() > 0) {
            documents.add(new Document("$match", mongoDBQueryHolder.getQuery()));
        }
        if (sqlCommandInfoHolder.getJoins() != null && !sqlCommandInfoHolder.getJoins().isEmpty()) {
            documents.addAll(mongoDBQueryHolder.getJoinPipeline());
        }
        if (!sqlCommandInfoHolder.getGoupBys().isEmpty() || sqlCommandInfoHolder.isTotalGroup()) {
            if (mongoDBQueryHolder.getProjection().get("_id") == null) {
                Document dgroup = new Document();
                dgroup.put("_id", (Object)new Document());
                for (Map.Entry<String, Object> keyValue : mongoDBQueryHolder.getProjection().entrySet()) {
                    if (keyValue.getKey().equals("_id")) continue;
                    dgroup.put(keyValue.getKey(), keyValue.getValue());
                }
                documents.add(new Document("$group", dgroup));
            } else {
                documents.add(new Document("$group", mongoDBQueryHolder.getProjection()));
            }
        }
        if (mongoDBQueryHolder.getHaving() != null && mongoDBQueryHolder.getHaving().size() > 0) {
            documents.add(new Document("$match", mongoDBQueryHolder.getHaving()));
        }
        if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
            documents.add(new Document("$sort", mongoDBQueryHolder.getSort()));
        }
        if (mongoDBQueryHolder.getOffset() != -1L) {
            documents.add(new Document("$skip", mongoDBQueryHolder.getOffset()));
        }
        if (mongoDBQueryHolder.getLimit() != -1L) {
            documents.add(new Document("$limit", mongoDBQueryHolder.getLimit()));
        }
        if (!(aliasProjection = mongoDBQueryHolder.getAliasProjection()).isEmpty()) {
            documents.add(new Document("$project", aliasProjection));
        }
        if (sqlCommandInfoHolder.getGoupBys().isEmpty() && !sqlCommandInfoHolder.isTotalGroup() && !mongoDBQueryHolder.getProjection().isEmpty()) {
            Document projection = mongoDBQueryHolder.getProjection();
            documents.add(new Document("$project", projection));
        }
        return documents;
    }

    private static String toJson(List<Document> documents) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.write("[", (Writer)stringWriter);
        IOUtils.write(Joiner.on(",").join(Lists.transform(documents, new Function<Document, String>(){

            @Override
            public String apply(@Nonnull Document document) {
                return document.toJson(relaxed);
            }
        })), (Writer)stringWriter);
        IOUtils.write("]", (Writer)stringWriter);
        return stringWriter.toString();
    }

    private String prettyPrintJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return gson.toJson(je);
    }

    public static class Builder {
        private Boolean aggregationAllowDiskUse = null;
        private Integer aggregationBatchSize = null;
        private InputStream inputStream;
        private Map<String, FieldType> fieldNameToFieldTypeMapping = new HashMap<String, FieldType>();
        private FieldType defaultFieldType = FieldType.UNKNOWN;

        public Builder sqlInputStream(InputStream inputStream) {
            Validate.notNull(inputStream);
            this.inputStream = inputStream;
            return this;
        }

        public Builder sqlString(String sql) {
            Validate.notNull(sql);
            this.inputStream = new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8));
            return this;
        }

        public Builder fieldNameToFieldTypeMapping(Map<String, FieldType> fieldNameToFieldTypeMapping) {
            Validate.notNull(fieldNameToFieldTypeMapping);
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
            return this;
        }

        public Builder defaultFieldType(FieldType defaultFieldType) {
            Validate.notNull((Object)defaultFieldType);
            this.defaultFieldType = defaultFieldType;
            return this;
        }

        public Builder aggregationAllowDiskUse(Boolean aggregationAllowDiskUse) {
            Validate.notNull(aggregationAllowDiskUse);
            this.aggregationAllowDiskUse = aggregationAllowDiskUse;
            return this;
        }

        public Builder aggregationBatchSize(Integer aggregationBatchSize) {
            Validate.notNull(aggregationBatchSize);
            this.aggregationBatchSize = aggregationBatchSize;
            return this;
        }

        public QueryConverter build() throws ParseException {
            return new QueryConverter(this.inputStream, this.fieldNameToFieldTypeMapping, this.defaultFieldType, this.aggregationAllowDiskUse, this.aggregationBatchSize);
        }
    }
}

