/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.NonCloseableBufferedOutputStream;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryConverter;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryResultIterator;
import com.github.vincentrussell.query.mongodb.sql.converter.TimeoutInputStream;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public class Main {
    public static final int DEFAULT_RESULT_BATCH_SIZE = 50;
    private static JsonWriterSettings JSON_WRITER_SETTINGS = new JsonWriterSettings(JsonMode.STRICT, "\t", "\n");
    public static final String ENTER_SQL_TEXT = "Enter input sql:\n\n ";
    private static final String DEFAULT_MONGO_PORT = "27017";
    public static final String D_AGGREGATION_ALLOW_DISK_USE = "aggregationAllowDiskUse";
    public static final String D_AGGREGATION_BATCH_SIZE = "aggregationBatchSize";

    public static Options buildOptions() {
        Options options = new Options();
        OptionGroup sourceOptionGroup = new OptionGroup();
        sourceOptionGroup.setRequired(false);
        sourceOptionGroup.addOption(Option.builder("s").longOpt("sourceFile").hasArg(true).required(false).desc("the source file.").build());
        sourceOptionGroup.addOption(Option.builder("i").longOpt("interactiveMode").hasArg(false).required(false).desc("interactive mode").build());
        sourceOptionGroup.addOption(Option.builder("sql").longOpt("sql").hasArg(true).required(false).desc("the sql select statement").build());
        options.addOption(Option.builder("d").longOpt("destinationFile").hasArg(true).required(false).desc("the destination file.  Defaults to System.out").build());
        options.addOption(Option.builder("h").longOpt("host").hasArg(true).required(false).desc("hosts and ports in the following format (host:port) default port is 27017").build());
        options.addOption(Option.builder("db").longOpt("database").hasArg(true).required(false).desc("mongo database").build());
        options.addOption(Option.builder("a").longOpt("auth database").hasArg(true).required(false).desc("auth mongo database").build());
        options.addOption(Option.builder("u").longOpt("username").hasArg(true).required(false).desc("usename").build());
        options.addOption(Option.builder("p").longOpt("password").hasArg(true).required(false).desc("password").build());
        options.addOption(Option.builder("b").longOpt("batchSize").hasArg(true).required(false).desc("batch size for query results").build());
        options.addOptionGroup(sourceOptionGroup);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ParseException, ClassNotFoundException, org.apache.commons.cli.ParseException {
        Options options = Main.buildOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter help = new HelpFormatter();
        help.setOptionComparator(new OptionComparator(Arrays.asList("s", "sql", "i", "d", "h", "db", "a", "u", "p", "b")));
        CommandLine cmd = null;
        try {
            OutputStream outputStream;
            InputStream inputStream;
            block26: {
                cmd = parser.parse(options, args);
                String source = cmd.getOptionValue("s");
                boolean interactiveMode = cmd.hasOption('i');
                String[] hosts = cmd.getOptionValues("h");
                String db = cmd.getOptionValue("db");
                String username = cmd.getOptionValue("u");
                String password = cmd.getOptionValue("p");
                String destination = cmd.getOptionValue("d");
                String authdb = cmd.getOptionValue("a");
                String sql = cmd.getOptionValue("sql");
                int batchSize = Integer.parseInt(cmd.getOptionValue("b", "50"));
                Main.isFalse(hosts != null && db == null, "provided option h, but missing db");
                Main.isFalse(username != null && (password == null || authdb == null), "provided option u, but missing p or a");
                Main.isTrue(interactiveMode || source != null || sql != null, "Missing required option: s or i or sql");
                inputStream = null;
                outputStream = null;
                try {
                    if (interactiveMode) {
                        inputStream = new TimeoutInputStream(System.in, 1L, TimeUnit.SECONDS);
                        System.out.println(ENTER_SQL_TEXT);
                    } else if (sql != null) {
                        inputStream = new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8));
                    } else {
                        File sourceFile = new File(source);
                        if (!sourceFile.exists()) {
                            throw new FileNotFoundException(source + " cannot be found");
                        }
                        inputStream = new FileInputStream(sourceFile);
                    }
                    if (destination != null) {
                        File destinationFile = new File(destination);
                        if (destinationFile.exists()) {
                            throw new IOException(destination + " already exists");
                        }
                        outputStream = new FileOutputStream(destinationFile);
                    } else {
                        outputStream = new NonCloseableBufferedOutputStream(System.out);
                    }
                    QueryConverter.Builder builder = new QueryConverter.Builder().sqlInputStream(inputStream);
                    if (System.getProperty(D_AGGREGATION_ALLOW_DISK_USE) != null) {
                        builder.aggregationAllowDiskUse(Boolean.valueOf(System.getProperty(D_AGGREGATION_ALLOW_DISK_USE)));
                    }
                    if (System.getProperty(D_AGGREGATION_BATCH_SIZE) != null) {
                        try {
                            builder.aggregationBatchSize(Integer.valueOf(System.getProperty(D_AGGREGATION_BATCH_SIZE)));
                        }
                        catch (NumberFormatException formatException) {
                            System.err.println(formatException.getMessage());
                        }
                    }
                    QueryConverter queryConverter = builder.build();
                    inputStream.close();
                    if (hosts != null) {
                        try (MongoClient mongoClient = null;){
                            mongoClient = Main.getMongoClient(hosts, authdb, username, password);
                            Object result = queryConverter.run(mongoClient.getDatabase(db));
                            if (Long.class.isInstance(result) || Long.TYPE.isInstance(result)) {
                                IOUtils.write("\n\n******Query Results:*********\n\n", outputStream);
                                IOUtils.write("" + result, outputStream);
                                IOUtils.write("\n\n", outputStream);
                                break block26;
                            }
                            if (!QueryResultIterator.class.isInstance(result)) break block26;
                            QueryResultIterator iterator = (QueryResultIterator)result;
                            if (FileOutputStream.class.isInstance(outputStream)) {
                                IOUtils.write("[", outputStream);
                                while (iterator.hasNext()) {
                                    IOUtils.write(((Document)iterator.next()).toJson(), outputStream);
                                    if (!iterator.hasNext()) continue;
                                    IOUtils.write(",\n", outputStream);
                                }
                                IOUtils.write("]", outputStream);
                                break block26;
                            }
                            IOUtils.write("\n\n******Query Results:*********\n\n", outputStream);
                            UnmodifiableIterator listIterator = Iterators.partition(iterator, batchSize);
                            while (listIterator.hasNext()) {
                                String continueString;
                                List documents = (List)listIterator.next();
                                IOUtils.write(Main.toJson(documents) + "\n\n", outputStream);
                                outputStream.flush();
                                if (!listIterator.hasNext()) continue;
                                do {
                                    if (!"n".equals((continueString = Main.getCharacterInput()).trim().toLowerCase())) continue;
                                    break block26;
                                } while (!"y".equals(continueString.trim().toLowerCase()));
                            }
                            break block26;
                        }
                    }
                    IOUtils.write("\n\n******Mongo Query:*********\n\n", outputStream);
                    queryConverter.write(outputStream);
                    IOUtils.write("\n\n", outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
        catch (org.apache.commons.cli.ParseException e) {
            System.err.println(e.getMessage());
            help.printHelp(Main.class.getName(), options, true);
            throw e;
        }
        System.exit(0);
    }

    private static String getCharacterInput() {
        Scanner scanner = new Scanner(System.in, Charsets.UTF_8.displayName());
        System.out.print("more results? (y/n): ");
        String choice = "";
        if (scanner.hasNext()) {
            choice = scanner.next();
        }
        return choice;
    }

    private static String toJson(List<Document> documents) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.write("[", (Writer)stringWriter);
        IOUtils.write(Joiner.on(",").join(Lists.transform(documents, new Function<Document, String>(){

            @Override
            public String apply(@Nonnull Document document) {
                return document.toJson(JSON_WRITER_SETTINGS);
            }
        })), (Writer)stringWriter);
        IOUtils.write("]", (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static MongoClient getMongoClient(String[] hosts, String authdb, String username, String password) {
        final Pattern hostAndPort = Pattern.compile("^(.[^:]*){1}([:]){0,1}(\\d+){0,1}$");
        List<ServerAddress> serverAddresses = Lists.transform(Arrays.asList(hosts), new Function<String, ServerAddress>(){

            @Override
            public ServerAddress apply(@Nonnull String string) {
                Matcher matcher = hostAndPort.matcher(string.trim());
                if (matcher.matches()) {
                    String hostname = matcher.group(1);
                    String port = matcher.group(3);
                    return new ServerAddress(hostname, port != null ? Integer.parseInt(port) : Integer.parseInt(Main.DEFAULT_MONGO_PORT));
                }
                throw new IllegalArgumentException(string + " doesn't appear to be a hostname.");
            }
        });
        if (username != null && password != null) {
            return new MongoClient(serverAddresses, Arrays.asList(MongoCredential.createCredential(username, authdb, password.toCharArray())));
        }
        return new MongoClient(serverAddresses);
    }

    private static void isTrue(boolean expression, String message) throws org.apache.commons.cli.ParseException {
        if (!expression) {
            throw new org.apache.commons.cli.ParseException(message);
        }
    }

    private static void isFalse(boolean expression, String message) throws org.apache.commons.cli.ParseException {
        if (expression) {
            throw new org.apache.commons.cli.ParseException(message);
        }
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private final List<String> orderList;

        public OptionComparator(List<String> orderList) {
            this.orderList = orderList;
        }

        @Override
        public int compare(Option o1, Option o2) {
            int index1 = this.orderList.indexOf(o1.getOpt());
            int index2 = this.orderList.indexOf(o2.getOpt());
            return index1 - index2;
        }
    }
}

